/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import javax.crypto.Cipher;

public class CipherCodec
extends ByteToMessageCodec<ByteBuf> {
    private final Cipher encrypt;
    private final Cipher decrypt;
    private byte[] inBuf = null;
    private byte[] outBuf = null;

    public CipherCodec(Cipher encrypt, Cipher decrypt) {
        this.encrypt = encrypt;
        this.decrypt = decrypt;
    }

    private byte[] inBuf(ByteBuf buf, int size) {
        if (this.inBuf == null || this.inBuf.length < size) {
            this.inBuf = new byte[size];
        }
        buf.readBytes(this.inBuf, 0, size);
        return this.inBuf;
    }

    private byte[] outBuf(int size) {
        if (this.outBuf == null || this.outBuf.length < size) {
            this.outBuf = new byte[size];
        }
        return this.outBuf;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        int readable = msg.readableBytes();
        byte[] inBuf = this.inBuf(msg, readable);
        int outSize = this.encrypt.getOutputSize(readable);
        byte[] outBuf = this.outBuf(outSize);
        int written = this.encrypt.update(inBuf, 0, readable, outBuf);
        out.writeBytes(outBuf, 0, written);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        int readable = msg.readableBytes();
        byte[] inBuf = this.inBuf(msg, readable);
        ByteBuf outBuf = ctx.alloc().heapBuffer(this.decrypt.getOutputSize(readable));
        int written = this.decrypt.update(inBuf, 0, readable, outBuf.array(), outBuf.arrayOffset());
        outBuf.writerIndex(written);
        out.add(outBuf);
    }
}

